/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij_plugins.dcraw;

import ij.IJ;
import ij.Menus;
import ij.Prefs;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Vector;
import net.sf.ij_plugins.dcraw.DCRawException;

public final class DCRawReader {
    public static final String SYSTEM_PROPERTY_DCRAW_BIN = "dcrawExecutable.path";
    private final Vector<LogListener> listeners = new Vector();
    private String dcrawBinPath;

    private static String dcrawExecutableName() {
        return IJ.isWindows() ? "dcraw/dcraw.exe" : "dcraw/dcraw";
    }

    public void addLogListener(LogListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeLogListener(LogListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void removeAllLogListeners() {
        this.listeners.clear();
    }

    public void validateDCRaw() throws DCRawException {
        if (this.dcrawBinPath == null) {
            this.dcrawBinPath = this.locateDCRAW();
        }
    }

    private String locateDCRAW() throws DCRawException {
        String systemDCRawExecutablePath = System.getProperty(SYSTEM_PROPERTY_DCRAW_BIN, null);
        if (systemDCRawExecutablePath != null) {
            File file = new File(systemDCRawExecutablePath);
            if (!file.exists()) {
                throw new DCRawException("System property 'dcrawExecutable.path' does not point to an existing DCRAW executable [" + file.getAbsolutePath() + "]");
            }
            this.dcrawBinPath = file.getAbsolutePath();
        } else if (Prefs.get((String)SYSTEM_PROPERTY_DCRAW_BIN, null) != null) {
            String path = Prefs.get((String)SYSTEM_PROPERTY_DCRAW_BIN, null);
            File file = new File(path);
            if (!file.exists()) {
                throw new DCRawException("ImageJ property 'dcrawExecutable.path' (IJ_Prefs.txt) does not point to an existing DCRAW executable [" + file.getAbsolutePath() + "]");
            }
            this.dcrawBinPath = new File(path).getAbsolutePath();
        } else if (Menus.getPlugInsPath() != null) {
            String path = Menus.getPlugInsPath() + File.separator + DCRawReader.dcrawExecutableName();
            File file = new File(path);
            if (!file.exists()) {
                throw new DCRawException("Unable to find DCRAW binary in ImageJ plugins folder. File does not exist: '" + file.getAbsolutePath() + "'.");
            }
            this.dcrawBinPath = new File(path).getAbsolutePath();
        } else {
            this.dcrawBinPath = DCRawReader.dcrawExecutableName();
            try {
                this.executeCommand(new String[]{this.dcrawBinPath});
            }
            catch (DCRawException ex) {
                throw new DCRawException("Failed to find DCRAW binary in system path.", ex);
            }
        }
        return this.dcrawBinPath;
    }

    public String executeCommand(String[] command) throws DCRawException {
        Process process;
        this.validateDCRaw();
        Object[] fullCommand = new String[command.length + 1];
        fullCommand[0] = this.dcrawBinPath;
        System.arraycopy(command, 0, fullCommand, 1, command.length);
        this.log("Executing command array: " + Arrays.toString(fullCommand));
        StringBuilder fullCommandStr = new StringBuilder();
        for (Object s : fullCommand) {
            if (s == null || ((String)s).trim().isEmpty()) continue;
            fullCommandStr.append((String)s).append(" ");
        }
        this.log("DCRAW command line: " + fullCommandStr.toString());
        String[] envp = new String[]{"CYGWIN=nodosfilewarning"};
        try {
            process = Runtime.getRuntime().exec(fullCommandStr.toString(), envp);
        }
        catch (IOException e) {
            throw new DCRawException("IO Error executing system command: '" + command[0] + "'.", e);
        }
        StreamGrabber errorStreamGrabber = new StreamGrabber(process.getErrorStream(), "DCRAW: ");
        StreamGrabber outputStreamGrabber = new StreamGrabber(process.getInputStream(), "DCRAW: ");
        try {
            errorStreamGrabber.start();
            outputStreamGrabber.start();
            int r = process.waitFor();
            if (r != 0) {
                StringBuilder message = new StringBuilder();
                message.append("Lookup thread terminated with code ").append(r).append(".");
                String errorOutput = errorStreamGrabber.getData().trim();
                if (errorOutput.length() > 0) {
                    message.append('\n').append(errorOutput);
                }
                throw new DCRawException(message.toString());
            }
            outputStreamGrabber.join();
        }
        catch (InterruptedException e) {
            StringBuilder message = new StringBuilder("Thread Error executing system command.");
            String errorOutput = errorStreamGrabber.getData().trim();
            if (errorOutput.length() > 0) {
                message.append('\n').append(errorOutput);
            }
            throw new DCRawException(message.toString(), e);
        }
        return outputStreamGrabber.getData();
    }

    private void log(String message) {
        for (LogListener listener : this.listeners) {
            listener.log(message);
        }
    }

    private class StreamGrabber
    extends Thread {
        private final InputStream inputStream;
        private final StringBuffer data = new StringBuffer();
        private final String statusPrefix;

        public StreamGrabber(InputStream inputStream, String statusPrefix) {
            this.inputStream = inputStream;
            this.statusPrefix = statusPrefix;
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
                while ((line = reader.readLine()) != null) {
                    this.data.append(line).append('\n');
                    String message = this.statusPrefix + line;
                    IJ.showStatus((String)message);
                    DCRawReader.this.log(message);
                }
                reader.close();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }

        public String getData() {
            return this.data.toString();
        }
    }

    public static interface LogListener {
        public void log(String var1);
    }

    public static enum InterpolationQualityOption {
        HIGH_SPEED("High-speed, low-quality bilinear", "0"),
        VNG("Variable Number of Gradients (VNG)", "1"),
        PPG("Patterned Pixel Grouping (PPG)", "2"),
        AHD("Adaptive Homogeneity-Directed (AHD)", "3");

        private final String name;
        private final String option;

        private InterpolationQualityOption(String name, String option) {
            this.name = name;
            this.option = option;
        }

        public static InterpolationQualityOption byName(String name) {
            for (InterpolationQualityOption v : InterpolationQualityOption.values()) {
                if (!v.toString().equals(name)) continue;
                return v;
            }
            throw new IllegalArgumentException("InterpolationQualityOption has no value with name '" + name + "'.");
        }

        public String getOption() {
            return this.option;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum FormatOption {
        F_8_BIT("8-bit", ""),
        F_16_BIT("16-bit", "-6"),
        F_16_BIT_LINEAR("16-bit linear", "-4");

        private final String name;
        private final String option;

        private FormatOption(String name, String option) {
            this.name = name;
            this.option = option;
        }

        public static FormatOption byName(String name) {
            for (FormatOption v : FormatOption.values()) {
                if (!v.toString().equals(name)) continue;
                return v;
            }
            throw new IllegalArgumentException("FormatOption has no value with name '" + name + "'.");
        }

        public String getOption() {
            return this.option;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum OutputColorSpaceOption {
        RAW("raw", "0"),
        SRGB("sRGB", "1"),
        ADOBE("Adobe", "2"),
        WIDE("Wide", "3"),
        PRO_PHOTO("ProPhoto", "4"),
        XYZ("XYZ", "5");

        private final String name;
        private final String option;

        private OutputColorSpaceOption(String name, String option) {
            this.name = name;
            this.option = option;
        }

        public static OutputColorSpaceOption byName(String name) {
            for (OutputColorSpaceOption v : OutputColorSpaceOption.values()) {
                if (!v.toString().equals(name)) continue;
                return v;
            }
            throw new IllegalArgumentException("OutputColorSpaceOption has no value with name '" + name + "'.");
        }

        public String getOption() {
            return this.option;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum WhiteBalanceOption {
        NONE("None", ""),
        CAMERA("Camera white balance", "-w"),
        AVERAGING("Averaging the entire image", "-a");

        private final String name;
        private final String option;

        private WhiteBalanceOption(String name, String option) {
            this.name = name;
            this.option = option;
        }

        public static WhiteBalanceOption byName(String name) {
            for (WhiteBalanceOption v : WhiteBalanceOption.values()) {
                if (!v.toString().equals(name)) continue;
                return v;
            }
            throw new IllegalArgumentException("WhiteBalanceOption has no value with name '" + name + "'.");
        }

        public String getOption() {
            return this.option;
        }

        public String toString() {
            return this.name;
        }
    }
}

