/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij_plugins.dcraw;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import net.sf.ij_plugins.dcraw.DCRawException;
import net.sf.ij_plugins.dcraw.DCRawReader;
import net.sf.ij_plugins.dcraw.DCRawVersion;

public class DCRawPlugin
implements PlugIn {
    private static final String TITLE = "DCRaw Reader";
    private static final String ABOUT = "The Digital Camera Raw Reader plugin opens raw image formats from over 500 cameras using\nDCRAW program created by Dave Coffin. Full list of supported cameras can be\nfound at DCRAW home page: http://www.cybercom.net/~dcoffin/dcraw/\n---\nThe DCRaw Reader plugin requires the DCRAW binary. Versions for various operating\nsystems can be downloaded through the Reader home page:\nhttp://ij-plugins.sourceforge.net/plugins/dcraw/ or through DCRAW home page.\n---\nBy default, the DCRaw Reader plugin looks for the DCRAW binary in subdirectory\n'dcraw' of ImageJ plugins folder. Alternative location can be specified by adding\nproperty '.dcrawExecutable.path' to ImageJ properties file IJ_Props.txt located in\nImageJ home directory. Example line that should be added to IJ_Props.txt:\n.dcrawExecutable.path=/apps/bin/dcraw.exe\nReading of 48 bit RGB images requires ImageJ v.1.35p or newer.";
    private static final Config CONFIG = new Config();

    private static void log(String message) {
        if (IJ.debugMode) {
            IJ.log((String)message);
        }
    }

    private static String toProcessedFileName(String rawFileName) {
        String processedExtension = ".tiff";
        int dotIndex = rawFileName.lastIndexOf(46);
        if (dotIndex < 0) {
            return rawFileName + ".tiff";
        }
        return rawFileName.substring(0, dotIndex) + ".tiff";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists() && !destFile.createNewFile()) {
            throw new IOException("Destination file cannot be created: " + destFile.getPath());
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private static <T> String[] asStrings(T[] v) {
        String[] r = new String[v.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = v[i].toString();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String arg) {
        block45: {
            String title = "DCRaw Reader (v." + DCRawVersion.getInstance() + ")";
            if ("about".equalsIgnoreCase(arg)) {
                IJ.showMessage((String)("About " + title), (String)ABOUT);
                return;
            }
            DCRawReader dcRawReader = new DCRawReader();
            dcRawReader.addLogListener(new DCRawReader.LogListener(){

                @Override
                public void log(String message) {
                    DCRawPlugin.log(message);
                }
            });
            File processedFile = null;
            boolean removeProcessed = false;
            File actualInput = null;
            try {
                String metadataOutput;
                try {
                    dcRawReader.validateDCRaw();
                }
                catch (DCRawException e) {
                    e.printStackTrace();
                    IJ.error((String)title, (String)e.getMessage());
                    IJ.showMessage((String)("About " + title), (String)ABOUT);
                    dcRawReader.removeAllLogListeners();
                    if ((DCRawPlugin.CONFIG.useTmpDir || removeProcessed) && processedFile != null && processedFile.exists() && !processedFile.delete()) {
                        IJ.error((String)title, (String)("Failed to delete the processed file: " + processedFile.getAbsolutePath()));
                    }
                    if (DCRawPlugin.CONFIG.useTmpDir && actualInput != null && actualInput.exists() && !actualInput.delete()) {
                        IJ.error((String)title, (String)("Failed to delete temporary copy of the raw file: " + actualInput.getAbsolutePath()));
                    }
                    return;
                }
                OpenDialog openDialog = new OpenDialog("Open", null);
                if (openDialog.getFileName() == null) {
                    return;
                }
                File rawFile = new File(openDialog.getDirectory(), openDialog.getFileName());
                IJ.showStatus((String)("Opening RAW file: " + rawFile.getName()));
                GenericDialog dialog = new GenericDialog(title);
                dialog.addCheckbox("Use_temporary_directory for processing", DCRawPlugin.CONFIG.useTmpDir);
                dialog.addChoice("White_balance", DCRawPlugin.asStrings(DCRawReader.WhiteBalanceOption.values()), DCRawPlugin.CONFIG.whiteBalance.toString());
                dialog.addCheckbox("Do_not_automatically_brighten the image", DCRawPlugin.CONFIG.doNotAutomaticallyBrightenTheImage);
                dialog.addChoice("Output_colorspace", DCRawPlugin.asStrings(DCRawReader.OutputColorSpaceOption.values()), DCRawPlugin.CONFIG.outputColorSpace.toString());
                dialog.addCheckbox("Document_mode (no color, no interpolation)", DCRawPlugin.CONFIG.documentMode);
                dialog.addCheckbox("Document_mode_without_scaling (totally raw)", DCRawPlugin.CONFIG.documentModeWithoutScaling);
                dialog.addChoice("Read_as", DCRawPlugin.asStrings(DCRawReader.FormatOption.values()), DCRawPlugin.CONFIG.format.toString());
                dialog.addChoice("Interpolation quality", DCRawPlugin.asStrings(DCRawReader.InterpolationQualityOption.values()), DCRawPlugin.CONFIG.interpolationQuality.toString());
                dialog.addCheckbox("Half_size", DCRawPlugin.CONFIG.halfSize);
                dialog.addCheckbox("Do_not_rotate or scale pixels (preserve orientation and aspect ratio)", DCRawPlugin.CONFIG.doNotRotate);
                dialog.addCheckbox("Show_metadata in Result window", DCRawPlugin.CONFIG.showMetadata);
                dialog.addHelp("http://ij-plugins.sourceforge.net/plugins/dcraw/");
                dialog.showDialog();
                if (dialog.wasCanceled()) {
                    return;
                }
                DCRawPlugin.CONFIG.useTmpDir = dialog.getNextBoolean();
                DCRawPlugin.CONFIG.whiteBalance = DCRawReader.WhiteBalanceOption.byName(dialog.getNextChoice());
                DCRawPlugin.CONFIG.doNotAutomaticallyBrightenTheImage = dialog.getNextBoolean();
                DCRawPlugin.CONFIG.outputColorSpace = DCRawReader.OutputColorSpaceOption.byName(dialog.getNextChoice());
                DCRawPlugin.CONFIG.documentMode = dialog.getNextBoolean();
                DCRawPlugin.CONFIG.documentModeWithoutScaling = dialog.getNextBoolean();
                DCRawPlugin.CONFIG.format = DCRawReader.FormatOption.byName(dialog.getNextChoice());
                DCRawPlugin.CONFIG.interpolationQuality = DCRawReader.InterpolationQualityOption.byName(dialog.getNextChoice());
                DCRawPlugin.CONFIG.halfSize = dialog.getNextBoolean();
                DCRawPlugin.CONFIG.doNotRotate = dialog.getNextBoolean();
                DCRawPlugin.CONFIG.showMetadata = dialog.getNextBoolean();
                if (DCRawPlugin.CONFIG.useTmpDir) {
                    try {
                        actualInput = File.createTempFile("dcraw_", "_" + rawFile.getName());
                        actualInput.deleteOnExit();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        IJ.error((String)title, (String)("Failed to create temporary file for processing. " + e.getMessage()));
                        dcRawReader.removeAllLogListeners();
                        if ((DCRawPlugin.CONFIG.useTmpDir || removeProcessed) && processedFile != null && processedFile.exists() && !processedFile.delete()) {
                            IJ.error((String)title, (String)("Failed to delete the processed file: " + processedFile.getAbsolutePath()));
                        }
                        if (DCRawPlugin.CONFIG.useTmpDir && actualInput != null && actualInput.exists() && !actualInput.delete()) {
                            IJ.error((String)title, (String)("Failed to delete temporary copy of the raw file: " + actualInput.getAbsolutePath()));
                        }
                        return;
                    }
                    String m = "Copying input to " + actualInput.getAbsolutePath();
                    IJ.showStatus((String)m);
                    DCRawPlugin.log(m);
                    try {
                        DCRawPlugin.copyFile(rawFile, actualInput);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        IJ.error((String)title, (String)("Failed to copy image to a temporary file for processing. " + e.getMessage()));
                        dcRawReader.removeAllLogListeners();
                        if ((DCRawPlugin.CONFIG.useTmpDir || removeProcessed) && processedFile != null && processedFile.exists() && !processedFile.delete()) {
                            IJ.error((String)title, (String)("Failed to delete the processed file: " + processedFile.getAbsolutePath()));
                        }
                        if (DCRawPlugin.CONFIG.useTmpDir && actualInput != null && actualInput.exists() && !actualInput.delete()) {
                            IJ.error((String)title, (String)("Failed to delete temporary copy of the raw file: " + actualInput.getAbsolutePath()));
                        }
                        return;
                    }
                }
                actualInput = rawFile;
                processedFile = new File(actualInput.getParentFile(), DCRawPlugin.toProcessedFileName(actualInput.getName()));
                removeProcessed = !processedFile.exists();
                ArrayList<String> commandList = new ArrayList<String>();
                commandList.add("-v");
                commandList.add("-T");
                commandList.add(DCRawPlugin.CONFIG.whiteBalance.getOption());
                if (DCRawPlugin.CONFIG.doNotAutomaticallyBrightenTheImage) {
                    commandList.add("-W");
                }
                commandList.add("-o");
                commandList.add(DCRawPlugin.CONFIG.outputColorSpace.getOption());
                if (DCRawPlugin.CONFIG.documentMode) {
                    commandList.add("-d");
                }
                if (DCRawPlugin.CONFIG.documentModeWithoutScaling) {
                    commandList.add("-D");
                }
                commandList.add(DCRawPlugin.CONFIG.format.getOption());
                commandList.add("-q");
                commandList.add(DCRawPlugin.CONFIG.interpolationQuality.getOption());
                if (DCRawPlugin.CONFIG.halfSize) {
                    commandList.add("-h");
                }
                if (DCRawPlugin.CONFIG.doNotRotate) {
                    commandList.add("-j");
                }
                boolean showMatadata = DCRawPlugin.CONFIG.showMetadata;
                commandList.add(actualInput.getAbsolutePath());
                String[] command = commandList.toArray(new String[commandList.size()]);
                try {
                    dcRawReader.executeCommand(command);
                }
                catch (DCRawException e) {
                    e.printStackTrace();
                    IJ.error((String)title, (String)e.getMessage());
                    IJ.showMessage((String)("About " + title), (String)ABOUT);
                    dcRawReader.removeAllLogListeners();
                    if ((DCRawPlugin.CONFIG.useTmpDir || removeProcessed) && processedFile != null && processedFile.exists() && !processedFile.delete()) {
                        IJ.error((String)title, (String)("Failed to delete the processed file: " + processedFile.getAbsolutePath()));
                    }
                    if (DCRawPlugin.CONFIG.useTmpDir && actualInput != null && actualInput.exists() && !actualInput.delete()) {
                        IJ.error((String)title, (String)("Failed to delete temporary copy of the raw file: " + actualInput.getAbsolutePath()));
                    }
                    return;
                }
                if (!processedFile.exists()) {
                    IJ.error((String)("Unable to locate DCRAW output PPM file: '" + processedFile.getAbsolutePath() + "'."));
                    return;
                }
                IJ.showStatus((String)("Opening: " + processedFile.getAbsolutePath()));
                ImagePlus imp = IJ.openImage((String)processedFile.getAbsolutePath());
                if (imp == null) {
                    IJ.error((String)TITLE, (String)("Failed to open converted image file: " + processedFile.getAbsolutePath()));
                } else {
                    imp.setTitle(rawFile.getName());
                    imp.show();
                }
                if (!showMatadata) break block45;
                String[] metadataCommand = new String[]{"-i", "-v", rawFile.getAbsolutePath()};
                try {
                    metadataOutput = dcRawReader.executeCommand(metadataCommand);
                }
                catch (DCRawException e) {
                    e.printStackTrace();
                    IJ.error((String)title, (String)e.getMessage());
                    IJ.showMessage((String)("About " + title), (String)ABOUT);
                    dcRawReader.removeAllLogListeners();
                    if ((DCRawPlugin.CONFIG.useTmpDir || removeProcessed) && processedFile != null && processedFile.exists() && !processedFile.delete()) {
                        IJ.error((String)title, (String)("Failed to delete the processed file: " + processedFile.getAbsolutePath()));
                    }
                    if (DCRawPlugin.CONFIG.useTmpDir && actualInput != null && actualInput.exists() && !actualInput.delete()) {
                        IJ.error((String)title, (String)("Failed to delete temporary copy of the raw file: " + actualInput.getAbsolutePath()));
                    }
                    return;
                }
                IJ.log((String)metadataOutput);
            }
            finally {
                dcRawReader.removeAllLogListeners();
                if ((DCRawPlugin.CONFIG.useTmpDir || removeProcessed) && processedFile != null && processedFile.exists() && !processedFile.delete()) {
                    IJ.error((String)title, (String)("Failed to delete the processed file: " + processedFile.getAbsolutePath()));
                }
                if (DCRawPlugin.CONFIG.useTmpDir && actualInput != null && actualInput.exists() && !actualInput.delete()) {
                    IJ.error((String)title, (String)("Failed to delete temporary copy of the raw file: " + actualInput.getAbsolutePath()));
                }
            }
        }
    }

    private static class Config {
        public DCRawReader.WhiteBalanceOption whiteBalance = DCRawReader.WhiteBalanceOption.CAMERA;
        public boolean doNotAutomaticallyBrightenTheImage;
        public DCRawReader.OutputColorSpaceOption outputColorSpace = DCRawReader.OutputColorSpaceOption.RAW;
        public boolean documentMode;
        public boolean documentModeWithoutScaling;
        public DCRawReader.FormatOption format = DCRawReader.FormatOption.F_8_BIT;
        public DCRawReader.InterpolationQualityOption interpolationQuality = DCRawReader.InterpolationQualityOption.HIGH_SPEED;
        public boolean halfSize;
        public boolean doNotRotate;
        public boolean showMetadata;
        boolean useTmpDir = true;

        private Config() {
        }
    }
}

